package zio.aws.ses.model
import zio.aws.ses.model.primitives.RenderedTemplate
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestRenderTemplateResponse(
    renderedTemplate: Optional[RenderedTemplate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.TestRenderTemplateResponse = {
    import TestRenderTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.TestRenderTemplateResponse
      .builder()
      .optionallyWith(
        renderedTemplate.map(value =>
          RenderedTemplate.unwrap(value): java.lang.String
        )
      )(_.renderedTemplate)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.TestRenderTemplateResponse.ReadOnly =
    zio.aws.ses.model.TestRenderTemplateResponse.wrap(buildAwsValue())
}
object TestRenderTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.TestRenderTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.TestRenderTemplateResponse =
      zio.aws.ses.model
        .TestRenderTemplateResponse(renderedTemplate.map(value => value))
    def renderedTemplate: Optional[RenderedTemplate]
    def getRenderedTemplate: ZIO[Any, AwsError, RenderedTemplate] =
      AwsError.unwrapOptionField("renderedTemplate", renderedTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.TestRenderTemplateResponse
  ) extends zio.aws.ses.model.TestRenderTemplateResponse.ReadOnly {
    override val renderedTemplate: Optional[RenderedTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renderedTemplate())
        .map(value => zio.aws.ses.model.primitives.RenderedTemplate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.TestRenderTemplateResponse
  ): zio.aws.ses.model.TestRenderTemplateResponse.ReadOnly = new Wrapper(impl)
}
