package zio.aws.ses
import zio.aws.ses.model.primitives.TemplateContent.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.ses.model.primitives.{
  Identity,
  PolicyName,
  Recipient,
  Policy,
  Address,
  ReceiptRuleName,
  VerificationToken
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Address extends zio.prelude.Subtype[String]
    type Address = zio.aws.ses.model.primitives.Address.Type
    object AmazonResourceName extends zio.prelude.Subtype[String]
    type AmazonResourceName =
      zio.aws.ses.model.primitives.AmazonResourceName.Type
    object ArrivalDate extends zio.prelude.Subtype[Instant]
    type ArrivalDate = zio.aws.ses.model.primitives.ArrivalDate.Type
    object BounceMessage extends zio.prelude.Subtype[String]
    type BounceMessage = zio.aws.ses.model.primitives.BounceMessage.Type
    object BounceSmtpReplyCode extends zio.prelude.Subtype[String]
    type BounceSmtpReplyCode =
      zio.aws.ses.model.primitives.BounceSmtpReplyCode.Type
    object BounceStatusCode extends zio.prelude.Subtype[String]
    type BounceStatusCode = zio.aws.ses.model.primitives.BounceStatusCode.Type
    object Charset extends zio.prelude.Subtype[String]
    type Charset = zio.aws.ses.model.primitives.Charset.Type
    object Cidr extends zio.prelude.Subtype[String]
    type Cidr = zio.aws.ses.model.primitives.Cidr.Type
    object ConfigurationSetName extends zio.prelude.Subtype[String]
    type ConfigurationSetName =
      zio.aws.ses.model.primitives.ConfigurationSetName.Type
    object Counter extends zio.prelude.Subtype[Long]
    type Counter = zio.aws.ses.model.primitives.Counter.Type
    object CustomRedirectDomain extends zio.prelude.Subtype[String]
    type CustomRedirectDomain =
      zio.aws.ses.model.primitives.CustomRedirectDomain.Type
    object DefaultDimensionValue extends zio.prelude.Subtype[String]
    type DefaultDimensionValue =
      zio.aws.ses.model.primitives.DefaultDimensionValue.Type
    object DiagnosticCode extends zio.prelude.Subtype[String]
    type DiagnosticCode = zio.aws.ses.model.primitives.DiagnosticCode.Type
    object DimensionName extends zio.prelude.Subtype[String]
    type DimensionName = zio.aws.ses.model.primitives.DimensionName.Type
    object Domain extends zio.prelude.Subtype[String]
    type Domain = zio.aws.ses.model.primitives.Domain.Type
    object DsnStatus extends zio.prelude.Subtype[String]
    type DsnStatus = zio.aws.ses.model.primitives.DsnStatus.Type
    object Enabled extends zio.prelude.Subtype[Boolean]
    type Enabled = zio.aws.ses.model.primitives.Enabled.Type
    object Error extends zio.prelude.Subtype[String]
    type Error = zio.aws.ses.model.primitives.Error.Type
    object EventDestinationName extends zio.prelude.Subtype[String]
    type EventDestinationName =
      zio.aws.ses.model.primitives.EventDestinationName.Type
    object Explanation extends zio.prelude.Subtype[String]
    type Explanation = zio.aws.ses.model.primitives.Explanation.Type
    object ExtensionFieldName extends zio.prelude.Subtype[String]
    type ExtensionFieldName =
      zio.aws.ses.model.primitives.ExtensionFieldName.Type
    object ExtensionFieldValue extends zio.prelude.Subtype[String]
    type ExtensionFieldValue =
      zio.aws.ses.model.primitives.ExtensionFieldValue.Type
    object FailureRedirectionURL extends zio.prelude.Subtype[String]
    type FailureRedirectionURL =
      zio.aws.ses.model.primitives.FailureRedirectionURL.Type
    object FromAddress extends zio.prelude.Subtype[String]
    type FromAddress = zio.aws.ses.model.primitives.FromAddress.Type
    object HeaderName extends zio.prelude.Subtype[String]
    type HeaderName = zio.aws.ses.model.primitives.HeaderName.Type
    object HeaderValue extends zio.prelude.Subtype[String]
    type HeaderValue = zio.aws.ses.model.primitives.HeaderValue.Type
    object HtmlPart extends zio.prelude.Subtype[String]
    type HtmlPart = zio.aws.ses.model.primitives.HtmlPart.Type
    object IAMRoleARN extends zio.prelude.Subtype[String]
    type IAMRoleARN = zio.aws.ses.model.primitives.IAMRoleARN.Type
    object Identity extends zio.prelude.Subtype[String]
    type Identity = zio.aws.ses.model.primitives.Identity.Type
    object LastAttemptDate extends zio.prelude.Subtype[Instant]
    type LastAttemptDate = zio.aws.ses.model.primitives.LastAttemptDate.Type
    object LastFreshStart extends zio.prelude.Subtype[Instant]
    type LastFreshStart = zio.aws.ses.model.primitives.LastFreshStart.Type
    object MailFromDomainName extends zio.prelude.Subtype[String]
    type MailFromDomainName =
      zio.aws.ses.model.primitives.MailFromDomainName.Type
    object Max24HourSend extends zio.prelude.Subtype[Double]
    type Max24HourSend = zio.aws.ses.model.primitives.Max24HourSend.Type
    object MaxItems extends zio.prelude.Subtype[Int]
    type MaxItems = zio.aws.ses.model.primitives.MaxItems.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.ses.model.primitives.MaxResults.Type
    object MaxSendRate extends zio.prelude.Subtype[Double]
    type MaxSendRate = zio.aws.ses.model.primitives.MaxSendRate.Type
    object MessageData extends zio.prelude.Subtype[String]
    type MessageData = zio.aws.ses.model.primitives.MessageData.Type
    object MessageId extends zio.prelude.Subtype[String]
    type MessageId = zio.aws.ses.model.primitives.MessageId.Type
    object MessageTagName extends zio.prelude.Subtype[String]
    type MessageTagName = zio.aws.ses.model.primitives.MessageTagName.Type
    object MessageTagValue extends zio.prelude.Subtype[String]
    type MessageTagValue = zio.aws.ses.model.primitives.MessageTagValue.Type
    object NextToken extends zio.prelude.Subtype[String]
    type NextToken = zio.aws.ses.model.primitives.NextToken.Type
    object NotificationTopic extends zio.prelude.Subtype[String]
    type NotificationTopic = zio.aws.ses.model.primitives.NotificationTopic.Type
    object Policy extends zio.prelude.Subtype[String]
    type Policy = zio.aws.ses.model.primitives.Policy.Type
    object PolicyName extends zio.prelude.Subtype[String]
    type PolicyName = zio.aws.ses.model.primitives.PolicyName.Type
    object RawMessageData extends zio.prelude.Subtype[Chunk[Byte]]
    type RawMessageData = zio.aws.ses.model.primitives.RawMessageData.Type
    object ReceiptFilterName extends zio.prelude.Subtype[String]
    type ReceiptFilterName = zio.aws.ses.model.primitives.ReceiptFilterName.Type
    object ReceiptRuleName extends zio.prelude.Subtype[String]
    type ReceiptRuleName = zio.aws.ses.model.primitives.ReceiptRuleName.Type
    object ReceiptRuleSetName extends zio.prelude.Subtype[String]
    type ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName.Type
    object Recipient extends zio.prelude.Subtype[String]
    type Recipient = zio.aws.ses.model.primitives.Recipient.Type
    object RemoteMta extends zio.prelude.Subtype[String]
    type RemoteMta = zio.aws.ses.model.primitives.RemoteMta.Type
    object RenderedTemplate extends zio.prelude.Subtype[String]
    type RenderedTemplate = zio.aws.ses.model.primitives.RenderedTemplate.Type
    object ReportingMta extends zio.prelude.Subtype[String]
    type ReportingMta = zio.aws.ses.model.primitives.ReportingMta.Type
    object S3BucketName extends zio.prelude.Subtype[String]
    type S3BucketName = zio.aws.ses.model.primitives.S3BucketName.Type
    object S3KeyPrefix extends zio.prelude.Subtype[String]
    type S3KeyPrefix = zio.aws.ses.model.primitives.S3KeyPrefix.Type
    object SentLast24Hours extends zio.prelude.Subtype[Double]
    type SentLast24Hours = zio.aws.ses.model.primitives.SentLast24Hours.Type
    object Subject extends zio.prelude.Subtype[String]
    type Subject = zio.aws.ses.model.primitives.Subject.Type
    object SubjectPart extends zio.prelude.Subtype[String]
    type SubjectPart = zio.aws.ses.model.primitives.SubjectPart.Type
    object SuccessRedirectionURL extends zio.prelude.Subtype[String]
    type SuccessRedirectionURL =
      zio.aws.ses.model.primitives.SuccessRedirectionURL.Type
    object TemplateContent extends zio.prelude.Subtype[String]
    type TemplateContent = zio.aws.ses.model.primitives.TemplateContent.Type
    object TemplateData extends zio.prelude.Subtype[String]
    type TemplateData = zio.aws.ses.model.primitives.TemplateData.Type
    object TemplateName extends zio.prelude.Subtype[String]
    type TemplateName = zio.aws.ses.model.primitives.TemplateName.Type
    object TextPart extends zio.prelude.Subtype[String]
    type TextPart = zio.aws.ses.model.primitives.TextPart.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.ses.model.primitives.Timestamp.Type
    object VerificationToken extends zio.prelude.Subtype[String]
    type VerificationToken = zio.aws.ses.model.primitives.VerificationToken.Type
  }
  type AddressList = List[Address]
  type BouncedRecipientInfoList = List[zio.aws.ses.model.BouncedRecipientInfo]
  type BulkEmailDestinationList = List[zio.aws.ses.model.BulkEmailDestination]
  type BulkEmailDestinationStatusList =
    List[zio.aws.ses.model.BulkEmailDestinationStatus]
  type CloudWatchDimensionConfigurations =
    List[zio.aws.ses.model.CloudWatchDimensionConfiguration]
  type ConfigurationSetAttributeList =
    List[zio.aws.ses.model.ConfigurationSetAttribute]
  type ConfigurationSets = List[zio.aws.ses.model.ConfigurationSet]
  type CustomVerificationEmailTemplates =
    List[zio.aws.ses.model.CustomVerificationEmailTemplate]
  type DkimAttributes = Map[Identity, zio.aws.ses.model.IdentityDkimAttributes]
  type EventDestinations = List[zio.aws.ses.model.EventDestination]
  type EventTypes = List[zio.aws.ses.model.EventType]
  type ExtensionFieldList = List[zio.aws.ses.model.ExtensionField]
  type IdentityList = List[Identity]
  type MailFromDomainAttributes =
    Map[Identity, zio.aws.ses.model.IdentityMailFromDomainAttributes]
  type MessageTagList = List[zio.aws.ses.model.MessageTag]
  type NotificationAttributes =
    Map[Identity, zio.aws.ses.model.IdentityNotificationAttributes]
  type PolicyMap = Map[PolicyName, Policy]
  type PolicyNameList = List[PolicyName]
  type ReceiptActionsList = List[zio.aws.ses.model.ReceiptAction]
  type ReceiptFilterList = List[zio.aws.ses.model.ReceiptFilter]
  type ReceiptRuleNamesList = List[ReceiptRuleName]
  type ReceiptRuleSetsLists = List[zio.aws.ses.model.ReceiptRuleSetMetadata]
  type ReceiptRulesList = List[zio.aws.ses.model.ReceiptRule]
  type RecipientsList = List[Recipient]
  type SendDataPointList = List[zio.aws.ses.model.SendDataPoint]
  type TemplateMetadataList = List[zio.aws.ses.model.TemplateMetadata]
  type VerificationAttributes =
    Map[Identity, zio.aws.ses.model.IdentityVerificationAttributes]
  type VerificationTokenList = List[VerificationToken]
}
