package zio.aws.ses.model
import zio.aws.ses.model.primitives.TemplateData
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BulkEmailDestination(
    destination: zio.aws.ses.model.Destination,
    replacementTags: Option[Iterable[zio.aws.ses.model.MessageTag]] = None,
    replacementTemplateData: Option[TemplateData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.BulkEmailDestination = {
    import BulkEmailDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.BulkEmailDestination
      .builder()
      .destination(destination.buildAwsValue())
      .optionallyWith(
        replacementTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replacementTags)
      .optionallyWith(
        replacementTemplateData.map(value =>
          TemplateData.unwrap(value): java.lang.String
        )
      )(_.replacementTemplateData)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.BulkEmailDestination.ReadOnly =
    zio.aws.ses.model.BulkEmailDestination.wrap(buildAwsValue())
}
object BulkEmailDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.BulkEmailDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.BulkEmailDestination =
      zio.aws.ses.model.BulkEmailDestination(
        destination.asEditable,
        replacementTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replacementTemplateData.map(value => value)
      )
    def destination: zio.aws.ses.model.Destination.ReadOnly
    def replacementTags: Option[List[zio.aws.ses.model.MessageTag.ReadOnly]]
    def replacementTemplateData: Option[TemplateData]
    def getDestination
        : ZIO[Any, Nothing, zio.aws.ses.model.Destination.ReadOnly] =
      ZIO.succeed(destination)
    def getReplacementTags
        : ZIO[Any, AwsError, List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      AwsError.unwrapOptionField("replacementTags", replacementTags)
    def getReplacementTemplateData: ZIO[Any, AwsError, TemplateData] = AwsError
      .unwrapOptionField("replacementTemplateData", replacementTemplateData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.BulkEmailDestination
  ) extends zio.aws.ses.model.BulkEmailDestination.ReadOnly {
    override val destination: zio.aws.ses.model.Destination.ReadOnly =
      zio.aws.ses.model.Destination.wrap(impl.destination())
    override val replacementTags
        : Option[List[zio.aws.ses.model.MessageTag.ReadOnly]] = scala
      .Option(impl.replacementTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.MessageTag.wrap(item)
        }.toList
      )
    override val replacementTemplateData: Option[TemplateData] = scala
      .Option(impl.replacementTemplateData())
      .map(value => zio.aws.ses.model.primitives.TemplateData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.BulkEmailDestination
  ): zio.aws.ses.model.BulkEmailDestination.ReadOnly = new Wrapper(impl)
}
