package zio.aws.ses.model
import zio.aws.ses.model.primitives.MessageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BulkEmailDestinationStatus(
    status: Option[zio.aws.ses.model.BulkEmailStatus] = None,
    error: Option[zio.aws.ses.model.primitives.Error] = None,
    messageId: Option[MessageId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.BulkEmailDestinationStatus = {
    import BulkEmailDestinationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.BulkEmailDestinationStatus
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        error.map(value =>
          zio.aws.ses.model.primitives.Error.unwrap(value): java.lang.String
        )
      )(_.error)
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.BulkEmailDestinationStatus.ReadOnly =
    zio.aws.ses.model.BulkEmailDestinationStatus.wrap(buildAwsValue())
}
object BulkEmailDestinationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.BulkEmailDestinationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.BulkEmailDestinationStatus =
      zio.aws.ses.model.BulkEmailDestinationStatus(
        status.map(value => value),
        error.map(value => value),
        messageId.map(value => value)
      )
    def status: Option[zio.aws.ses.model.BulkEmailStatus]
    def error: Option[zio.aws.ses.model.primitives.Error]
    def messageId: Option[MessageId]
    def getStatus: ZIO[Any, AwsError, zio.aws.ses.model.BulkEmailStatus] =
      AwsError.unwrapOptionField("status", status)
    def getError: ZIO[Any, AwsError, zio.aws.ses.model.primitives.Error] =
      AwsError.unwrapOptionField("error", error)
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.BulkEmailDestinationStatus
  ) extends zio.aws.ses.model.BulkEmailDestinationStatus.ReadOnly {
    override val status: Option[zio.aws.ses.model.BulkEmailStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ses.model.BulkEmailStatus.wrap(value))
    override val error: Option[zio.aws.ses.model.primitives.Error] = scala
      .Option(impl.error())
      .map(value => zio.aws.ses.model.primitives.Error(value))
    override val messageId: Option[MessageId] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.ses.model.primitives.MessageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.BulkEmailDestinationStatus
  ): zio.aws.ses.model.BulkEmailDestinationStatus.ReadOnly = new Wrapper(impl)
}
