package zio.aws.ses.model
import zio.aws.ses.model.primitives.{ReceiptRuleName, ReceiptRuleSetName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateReceiptRuleRequest(
    ruleSetName: ReceiptRuleSetName,
    after: Option[ReceiptRuleName] = None,
    rule: zio.aws.ses.model.ReceiptRule
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest = {
    import CreateReceiptRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest
      .builder()
      .ruleSetName(ReceiptRuleSetName.unwrap(ruleSetName): java.lang.String)
      .optionallyWith(
        after.map(value => ReceiptRuleName.unwrap(value): java.lang.String)
      )(_.after)
      .rule(rule.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ses.model.CreateReceiptRuleRequest.ReadOnly =
    zio.aws.ses.model.CreateReceiptRuleRequest.wrap(buildAwsValue())
}
object CreateReceiptRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.CreateReceiptRuleRequest =
      zio.aws.ses.model.CreateReceiptRuleRequest(
        ruleSetName,
        after.map(value => value),
        rule.asEditable
      )
    def ruleSetName: ReceiptRuleSetName
    def after: Option[ReceiptRuleName]
    def rule: zio.aws.ses.model.ReceiptRule.ReadOnly
    def getRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(ruleSetName)
    def getAfter: ZIO[Any, AwsError, ReceiptRuleName] =
      AwsError.unwrapOptionField("after", after)
    def getRule: ZIO[Any, Nothing, zio.aws.ses.model.ReceiptRule.ReadOnly] =
      ZIO.succeed(rule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest
  ) extends zio.aws.ses.model.CreateReceiptRuleRequest.ReadOnly {
    override val ruleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName(impl.ruleSetName())
    override val after: Option[ReceiptRuleName] = scala
      .Option(impl.after())
      .map(value => zio.aws.ses.model.primitives.ReceiptRuleName(value))
    override val rule: zio.aws.ses.model.ReceiptRule.ReadOnly =
      zio.aws.ses.model.ReceiptRule.wrap(impl.rule())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest
  ): zio.aws.ses.model.CreateReceiptRuleRequest.ReadOnly = new Wrapper(impl)
}
