package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  TemplateName,
  FromAddress,
  FailureRedirectionURL,
  SuccessRedirectionURL,
  Subject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CustomVerificationEmailTemplate(
    templateName: Option[TemplateName] = None,
    fromEmailAddress: Option[FromAddress] = None,
    templateSubject: Option[Subject] = None,
    successRedirectionURL: Option[SuccessRedirectionURL] = None,
    failureRedirectionURL: Option[FailureRedirectionURL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate = {
    import CustomVerificationEmailTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate
      .builder()
      .optionallyWith(
        templateName.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        fromEmailAddress.map(value =>
          FromAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        templateSubject.map(value => Subject.unwrap(value): java.lang.String)
      )(_.templateSubject)
      .optionallyWith(
        successRedirectionURL.map(value =>
          SuccessRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.successRedirectionURL)
      .optionallyWith(
        failureRedirectionURL.map(value =>
          FailureRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.failureRedirectionURL)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly =
    zio.aws.ses.model.CustomVerificationEmailTemplate.wrap(buildAwsValue())
}
object CustomVerificationEmailTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.CustomVerificationEmailTemplate =
      zio.aws.ses.model.CustomVerificationEmailTemplate(
        templateName.map(value => value),
        fromEmailAddress.map(value => value),
        templateSubject.map(value => value),
        successRedirectionURL.map(value => value),
        failureRedirectionURL.map(value => value)
      )
    def templateName: Option[TemplateName]
    def fromEmailAddress: Option[FromAddress]
    def templateSubject: Option[Subject]
    def successRedirectionURL: Option[SuccessRedirectionURL]
    def failureRedirectionURL: Option[FailureRedirectionURL]
    def getTemplateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getFromEmailAddress: ZIO[Any, AwsError, FromAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getTemplateSubject: ZIO[Any, AwsError, Subject] =
      AwsError.unwrapOptionField("templateSubject", templateSubject)
    def getSuccessRedirectionURL: ZIO[Any, AwsError, SuccessRedirectionURL] =
      AwsError.unwrapOptionField("successRedirectionURL", successRedirectionURL)
    def getFailureRedirectionURL: ZIO[Any, AwsError, FailureRedirectionURL] =
      AwsError.unwrapOptionField("failureRedirectionURL", failureRedirectionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate
  ) extends zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly {
    override val templateName: Option[TemplateName] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.ses.model.primitives.TemplateName(value))
    override val fromEmailAddress: Option[FromAddress] = scala
      .Option(impl.fromEmailAddress())
      .map(value => zio.aws.ses.model.primitives.FromAddress(value))
    override val templateSubject: Option[Subject] = scala
      .Option(impl.templateSubject())
      .map(value => zio.aws.ses.model.primitives.Subject(value))
    override val successRedirectionURL: Option[SuccessRedirectionURL] = scala
      .Option(impl.successRedirectionURL())
      .map(value => zio.aws.ses.model.primitives.SuccessRedirectionURL(value))
    override val failureRedirectionURL: Option[FailureRedirectionURL] = scala
      .Option(impl.failureRedirectionURL())
      .map(value => zio.aws.ses.model.primitives.FailureRedirectionURL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate
  ): zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly = new Wrapper(
    impl
  )
}
