package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeliveryOptions(
    tlsPolicy: Option[zio.aws.ses.model.TlsPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeliveryOptions = {
    import DeliveryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeliveryOptions
      .builder()
      .optionallyWith(tlsPolicy.map(value => value.unwrap))(_.tlsPolicy)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DeliveryOptions.ReadOnly =
    zio.aws.ses.model.DeliveryOptions.wrap(buildAwsValue())
}
object DeliveryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeliveryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DeliveryOptions =
      zio.aws.ses.model.DeliveryOptions(tlsPolicy.map(value => value))
    def tlsPolicy: Option[zio.aws.ses.model.TlsPolicy]
    def getTlsPolicy: ZIO[Any, AwsError, zio.aws.ses.model.TlsPolicy] =
      AwsError.unwrapOptionField("tlsPolicy", tlsPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeliveryOptions
  ) extends zio.aws.ses.model.DeliveryOptions.ReadOnly {
    override val tlsPolicy: Option[zio.aws.ses.model.TlsPolicy] = scala
      .Option(impl.tlsPolicy())
      .map(value => zio.aws.ses.model.TlsPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeliveryOptions
  ): zio.aws.ses.model.DeliveryOptions.ReadOnly = new Wrapper(impl)
}
