package zio.aws.ses.model
import zio.aws.ses.model.primitives.{ExtensionFieldValue, ExtensionFieldName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExtensionField(
    name: ExtensionFieldName,
    value: ExtensionFieldValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ExtensionField = {
    import ExtensionField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ExtensionField
      .builder()
      .name(ExtensionFieldName.unwrap(name): java.lang.String)
      .value(ExtensionFieldValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ExtensionField.ReadOnly =
    zio.aws.ses.model.ExtensionField.wrap(buildAwsValue())
}
object ExtensionField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ExtensionField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ExtensionField =
      zio.aws.ses.model.ExtensionField(name, value)
    def name: ExtensionFieldName
    def value: ExtensionFieldValue
    def getName: ZIO[Any, Nothing, ExtensionFieldName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, ExtensionFieldValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ExtensionField
  ) extends zio.aws.ses.model.ExtensionField.ReadOnly {
    override val name: ExtensionFieldName =
      zio.aws.ses.model.primitives.ExtensionFieldName(impl.name())
    override val value: ExtensionFieldValue =
      zio.aws.ses.model.primitives.ExtensionFieldValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ExtensionField
  ): zio.aws.ses.model.ExtensionField.ReadOnly = new Wrapper(impl)
}
