package zio.aws.ses.model
import zio.aws.ses.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetIdentityDkimAttributesResponse(
    dkimAttributes: Map[Identity, zio.aws.ses.model.IdentityDkimAttributes]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesResponse = {
    import GetIdentityDkimAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesResponse
      .builder()
      .dkimAttributes(
        dkimAttributes
          .map({ case (key, value) =>
            (Identity.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.GetIdentityDkimAttributesResponse.ReadOnly =
    zio.aws.ses.model.GetIdentityDkimAttributesResponse.wrap(buildAwsValue())
}
object GetIdentityDkimAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetIdentityDkimAttributesResponse =
      zio.aws.ses.model.GetIdentityDkimAttributesResponse(dkimAttributes.map({
        case (key, value) =>
          key -> value.asEditable
      }))
    def dkimAttributes
        : Map[Identity, zio.aws.ses.model.IdentityDkimAttributes.ReadOnly]
    def getDkimAttributes: ZIO[Any, Nothing, Map[
      Identity,
      zio.aws.ses.model.IdentityDkimAttributes.ReadOnly
    ]] = ZIO.succeed(dkimAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesResponse
  ) extends zio.aws.ses.model.GetIdentityDkimAttributesResponse.ReadOnly {
    override val dkimAttributes
        : Map[Identity, zio.aws.ses.model.IdentityDkimAttributes.ReadOnly] =
      impl
        .dkimAttributes()
        .asScala
        .map({ case (key, value) =>
          zio.aws.ses.model.primitives.Identity(
            key
          ) -> zio.aws.ses.model.IdentityDkimAttributes.wrap(value)
        })
        .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesResponse
  ): zio.aws.ses.model.GetIdentityDkimAttributesResponse.ReadOnly = new Wrapper(
    impl
  )
}
