package zio.aws.ses.model
import zio.aws.ses.model.primitives.TemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTemplateRequest(templateName: TemplateName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetTemplateRequest = {
    import GetTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.GetTemplateRequest.ReadOnly =
    zio.aws.ses.model.GetTemplateRequest.wrap(buildAwsValue())
}
object GetTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetTemplateRequest =
      zio.aws.ses.model.GetTemplateRequest(templateName)
    def templateName: TemplateName
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetTemplateRequest
  ) extends zio.aws.ses.model.GetTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetTemplateRequest
  ): zio.aws.ses.model.GetTemplateRequest.ReadOnly = new Wrapper(impl)
}
