package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Enabled, NotificationTopic}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IdentityNotificationAttributes(
    bounceTopic: NotificationTopic,
    complaintTopic: NotificationTopic,
    deliveryTopic: NotificationTopic,
    forwardingEnabled: Enabled,
    headersInBounceNotificationsEnabled: Option[Enabled] = None,
    headersInComplaintNotificationsEnabled: Option[Enabled] = None,
    headersInDeliveryNotificationsEnabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.IdentityNotificationAttributes = {
    import IdentityNotificationAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.IdentityNotificationAttributes
      .builder()
      .bounceTopic(NotificationTopic.unwrap(bounceTopic): java.lang.String)
      .complaintTopic(
        NotificationTopic.unwrap(complaintTopic): java.lang.String
      )
      .deliveryTopic(NotificationTopic.unwrap(deliveryTopic): java.lang.String)
      .forwardingEnabled(Enabled.unwrap(forwardingEnabled): java.lang.Boolean)
      .optionallyWith(
        headersInBounceNotificationsEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.headersInBounceNotificationsEnabled)
      .optionallyWith(
        headersInComplaintNotificationsEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.headersInComplaintNotificationsEnabled)
      .optionallyWith(
        headersInDeliveryNotificationsEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.headersInDeliveryNotificationsEnabled)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.IdentityNotificationAttributes.ReadOnly =
    zio.aws.ses.model.IdentityNotificationAttributes.wrap(buildAwsValue())
}
object IdentityNotificationAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.IdentityNotificationAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.IdentityNotificationAttributes =
      zio.aws.ses.model.IdentityNotificationAttributes(
        bounceTopic,
        complaintTopic,
        deliveryTopic,
        forwardingEnabled,
        headersInBounceNotificationsEnabled.map(value => value),
        headersInComplaintNotificationsEnabled.map(value => value),
        headersInDeliveryNotificationsEnabled.map(value => value)
      )
    def bounceTopic: NotificationTopic
    def complaintTopic: NotificationTopic
    def deliveryTopic: NotificationTopic
    def forwardingEnabled: Enabled
    def headersInBounceNotificationsEnabled: Option[Enabled]
    def headersInComplaintNotificationsEnabled: Option[Enabled]
    def headersInDeliveryNotificationsEnabled: Option[Enabled]
    def getBounceTopic: ZIO[Any, Nothing, NotificationTopic] =
      ZIO.succeed(bounceTopic)
    def getComplaintTopic: ZIO[Any, Nothing, NotificationTopic] =
      ZIO.succeed(complaintTopic)
    def getDeliveryTopic: ZIO[Any, Nothing, NotificationTopic] =
      ZIO.succeed(deliveryTopic)
    def getForwardingEnabled: ZIO[Any, Nothing, Enabled] =
      ZIO.succeed(forwardingEnabled)
    def getHeadersInBounceNotificationsEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField(
        "headersInBounceNotificationsEnabled",
        headersInBounceNotificationsEnabled
      )
    def getHeadersInComplaintNotificationsEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField(
        "headersInComplaintNotificationsEnabled",
        headersInComplaintNotificationsEnabled
      )
    def getHeadersInDeliveryNotificationsEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField(
        "headersInDeliveryNotificationsEnabled",
        headersInDeliveryNotificationsEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.IdentityNotificationAttributes
  ) extends zio.aws.ses.model.IdentityNotificationAttributes.ReadOnly {
    override val bounceTopic: NotificationTopic =
      zio.aws.ses.model.primitives.NotificationTopic(impl.bounceTopic())
    override val complaintTopic: NotificationTopic =
      zio.aws.ses.model.primitives.NotificationTopic(impl.complaintTopic())
    override val deliveryTopic: NotificationTopic =
      zio.aws.ses.model.primitives.NotificationTopic(impl.deliveryTopic())
    override val forwardingEnabled: Enabled =
      zio.aws.ses.model.primitives.Enabled(impl.forwardingEnabled())
    override val headersInBounceNotificationsEnabled: Option[Enabled] = scala
      .Option(impl.headersInBounceNotificationsEnabled())
      .map(value => zio.aws.ses.model.primitives.Enabled(value))
    override val headersInComplaintNotificationsEnabled: Option[Enabled] = scala
      .Option(impl.headersInComplaintNotificationsEnabled())
      .map(value => zio.aws.ses.model.primitives.Enabled(value))
    override val headersInDeliveryNotificationsEnabled: Option[Enabled] = scala
      .Option(impl.headersInDeliveryNotificationsEnabled())
      .map(value => zio.aws.ses.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.IdentityNotificationAttributes
  ): zio.aws.ses.model.IdentityNotificationAttributes.ReadOnly = new Wrapper(
    impl
  )
}
