package zio.aws.ses.model
import scala.jdk.CollectionConverters.*
sealed trait InvocationType {
  def unwrap: software.amazon.awssdk.services.ses.model.InvocationType
}
object InvocationType {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.InvocationType
  ): zio.aws.ses.model.InvocationType = value match {
    case software.amazon.awssdk.services.ses.model.InvocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.InvocationType.EVENT =>
      val r = Event
      r
    case software.amazon.awssdk.services.ses.model.InvocationType.REQUEST_RESPONSE =>
      val r = RequestResponse
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.InvocationType {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.InvocationType =
      software.amazon.awssdk.services.ses.model.InvocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object Event extends zio.aws.ses.model.InvocationType {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.InvocationType =
      software.amazon.awssdk.services.ses.model.InvocationType.EVENT
  }
  case object RequestResponse extends zio.aws.ses.model.InvocationType {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.InvocationType =
      software.amazon.awssdk.services.ses.model.InvocationType.REQUEST_RESPONSE
  }
}
