package zio.aws.ses.model
import java.lang.Integer
import zio.aws.ses.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCustomVerificationEmailTemplatesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest = {
    import ListCustomVerificationEmailTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest.ReadOnly =
    zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest
      .wrap(buildAwsValue())
}
object ListCustomVerificationEmailTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest =
      zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest
  ) extends zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ses.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest
  ): zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
