package zio.aws.ses.model
import zio.aws.ses.model.primitives.{NextToken, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListIdentitiesResponse(
    identities: Iterable[Identity],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListIdentitiesResponse = {
    import ListIdentitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListIdentitiesResponse
      .builder()
      .identities(identities.map { item =>
        Identity.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListIdentitiesResponse.ReadOnly =
    zio.aws.ses.model.ListIdentitiesResponse.wrap(buildAwsValue())
}
object ListIdentitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListIdentitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListIdentitiesResponse = zio.aws.ses.model
      .ListIdentitiesResponse(identities, nextToken.map(value => value))
    def identities: List[Identity]
    def nextToken: Option[NextToken]
    def getIdentities: ZIO[Any, Nothing, List[Identity]] =
      ZIO.succeed(identities)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListIdentitiesResponse
  ) extends zio.aws.ses.model.ListIdentitiesResponse.ReadOnly {
    override val identities: List[Identity] = impl
      .identities()
      .asScala
      .map { item =>
        zio.aws.ses.model.primitives.Identity(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListIdentitiesResponse
  ): zio.aws.ses.model.ListIdentitiesResponse.ReadOnly = new Wrapper(impl)
}
