package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListReceiptFiltersResponse(
    filters: Option[Iterable[zio.aws.ses.model.ReceiptFilter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListReceiptFiltersResponse = {
    import ListReceiptFiltersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListReceiptFiltersResponse
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListReceiptFiltersResponse.ReadOnly =
    zio.aws.ses.model.ListReceiptFiltersResponse.wrap(buildAwsValue())
}
object ListReceiptFiltersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListReceiptFiltersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListReceiptFiltersResponse =
      zio.aws.ses.model.ListReceiptFiltersResponse(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def filters: Option[List[zio.aws.ses.model.ReceiptFilter.ReadOnly]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ses.model.ReceiptFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListReceiptFiltersResponse
  ) extends zio.aws.ses.model.ListReceiptFiltersResponse.ReadOnly {
    override val filters
        : Option[List[zio.aws.ses.model.ReceiptFilter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.ReceiptFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListReceiptFiltersResponse
  ): zio.aws.ses.model.ListReceiptFiltersResponse.ReadOnly = new Wrapper(impl)
}
