package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Message(
    subject: zio.aws.ses.model.Content,
    body: zio.aws.ses.model.Body
) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.Message = {
    import Message.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.Message
      .builder()
      .subject(subject.buildAwsValue())
      .body(body.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ses.model.Message.ReadOnly =
    zio.aws.ses.model.Message.wrap(buildAwsValue())
}
object Message {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.Message] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.Message =
      zio.aws.ses.model.Message(subject.asEditable, body.asEditable)
    def subject: zio.aws.ses.model.Content.ReadOnly
    def body: zio.aws.ses.model.Body.ReadOnly
    def getSubject: ZIO[Any, Nothing, zio.aws.ses.model.Content.ReadOnly] =
      ZIO.succeed(subject)
    def getBody: ZIO[Any, Nothing, zio.aws.ses.model.Body.ReadOnly] =
      ZIO.succeed(body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.Message
  ) extends zio.aws.ses.model.Message.ReadOnly {
    override val subject: zio.aws.ses.model.Content.ReadOnly =
      zio.aws.ses.model.Content.wrap(impl.subject())
    override val body: zio.aws.ses.model.Body.ReadOnly =
      zio.aws.ses.model.Body.wrap(impl.body())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.Message
  ): zio.aws.ses.model.Message.ReadOnly = new Wrapper(impl)
}
