package zio.aws.ses.model
import scala.jdk.CollectionConverters.*
sealed trait NotificationType {
  def unwrap: software.amazon.awssdk.services.ses.model.NotificationType
}
object NotificationType {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.NotificationType
  ): zio.aws.ses.model.NotificationType = value match {
    case software.amazon.awssdk.services.ses.model.NotificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.NotificationType.BOUNCE =>
      val r = Bounce
      r
    case software.amazon.awssdk.services.ses.model.NotificationType.COMPLAINT =>
      val r = Complaint
      r
    case software.amazon.awssdk.services.ses.model.NotificationType.DELIVERY =>
      val r = Delivery
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.NotificationType =
      software.amazon.awssdk.services.ses.model.NotificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object Bounce extends zio.aws.ses.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.NotificationType =
      software.amazon.awssdk.services.ses.model.NotificationType.BOUNCE
  }
  case object Complaint extends zio.aws.ses.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.NotificationType =
      software.amazon.awssdk.services.ses.model.NotificationType.COMPLAINT
  }
  case object Delivery extends zio.aws.ses.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.NotificationType =
      software.amazon.awssdk.services.ses.model.NotificationType.DELIVERY
  }
}
