package zio.aws.ses.model
import scala.jdk.CollectionConverters.*
sealed trait ReceiptFilterPolicy {
  def unwrap: software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy
}
object ReceiptFilterPolicy {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy
  ): zio.aws.ses.model.ReceiptFilterPolicy = value match {
    case software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy.BLOCK =>
      val r = Block
      r
    case software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy.ALLOW =>
      val r = Allow
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ses.model.ReceiptFilterPolicy {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy =
      software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object Block extends zio.aws.ses.model.ReceiptFilterPolicy {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy =
      software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy.BLOCK
  }
  case object Allow extends zio.aws.ses.model.ReceiptFilterPolicy {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy =
      software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy.ALLOW
  }
}
