package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Recipient, Enabled, ReceiptRuleName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReceiptRule(
    name: ReceiptRuleName,
    enabled: Option[Enabled] = None,
    tlsPolicy: Option[zio.aws.ses.model.TlsPolicy] = None,
    recipients: Option[Iterable[Recipient]] = None,
    actions: Option[Iterable[zio.aws.ses.model.ReceiptAction]] = None,
    scanEnabled: Option[Enabled] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.ReceiptRule = {
    import ReceiptRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ReceiptRule
      .builder()
      .name(ReceiptRuleName.unwrap(name): java.lang.String)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(tlsPolicy.map(value => value.unwrap))(_.tlsPolicy)
      .optionallyWith(
        recipients.map(value =>
          value.map { item =>
            Recipient.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.recipients)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(
        scanEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.scanEnabled)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ReceiptRule.ReadOnly =
    zio.aws.ses.model.ReceiptRule.wrap(buildAwsValue())
}
object ReceiptRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.ReceiptRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ReceiptRule =
      zio.aws.ses.model.ReceiptRule(
        name,
        enabled.map(value => value),
        tlsPolicy.map(value => value),
        recipients.map(value => value),
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanEnabled.map(value => value)
      )
    def name: ReceiptRuleName
    def enabled: Option[Enabled]
    def tlsPolicy: Option[zio.aws.ses.model.TlsPolicy]
    def recipients: Option[List[Recipient]]
    def actions: Option[List[zio.aws.ses.model.ReceiptAction.ReadOnly]]
    def scanEnabled: Option[Enabled]
    def getName: ZIO[Any, Nothing, ReceiptRuleName] = ZIO.succeed(name)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getTlsPolicy: ZIO[Any, AwsError, zio.aws.ses.model.TlsPolicy] =
      AwsError.unwrapOptionField("tlsPolicy", tlsPolicy)
    def getRecipients: ZIO[Any, AwsError, List[Recipient]] =
      AwsError.unwrapOptionField("recipients", recipients)
    def getActions
        : ZIO[Any, AwsError, List[zio.aws.ses.model.ReceiptAction.ReadOnly]] =
      AwsError.unwrapOptionField("actions", actions)
    def getScanEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("scanEnabled", scanEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ReceiptRule
  ) extends zio.aws.ses.model.ReceiptRule.ReadOnly {
    override val name: ReceiptRuleName =
      zio.aws.ses.model.primitives.ReceiptRuleName(impl.name())
    override val enabled: Option[Enabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.ses.model.primitives.Enabled(value))
    override val tlsPolicy: Option[zio.aws.ses.model.TlsPolicy] = scala
      .Option(impl.tlsPolicy())
      .map(value => zio.aws.ses.model.TlsPolicy.wrap(value))
    override val recipients: Option[List[Recipient]] = scala
      .Option(impl.recipients())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.primitives.Recipient(item)
        }.toList
      )
    override val actions
        : Option[List[zio.aws.ses.model.ReceiptAction.ReadOnly]] = scala
      .Option(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.ReceiptAction.wrap(item)
        }.toList
      )
    override val scanEnabled: Option[Enabled] = scala
      .Option(impl.scanEnabled())
      .map(value => zio.aws.ses.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ReceiptRule
  ): zio.aws.ses.model.ReceiptRule.ReadOnly = new Wrapper(impl)
}
