package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  AmazonResourceName,
  Explanation,
  Address,
  MessageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SendBounceRequest(
    originalMessageId: MessageId,
    bounceSender: Address,
    explanation: Option[Explanation] = None,
    messageDsn: Option[zio.aws.ses.model.MessageDsn] = None,
    bouncedRecipientInfoList: Iterable[zio.aws.ses.model.BouncedRecipientInfo],
    bounceSenderArn: Option[AmazonResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendBounceRequest = {
    import SendBounceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendBounceRequest
      .builder()
      .originalMessageId(MessageId.unwrap(originalMessageId): java.lang.String)
      .bounceSender(Address.unwrap(bounceSender): java.lang.String)
      .optionallyWith(
        explanation.map(value => Explanation.unwrap(value): java.lang.String)
      )(_.explanation)
      .optionallyWith(messageDsn.map(value => value.buildAwsValue()))(
        _.messageDsn
      )
      .bouncedRecipientInfoList(bouncedRecipientInfoList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        bounceSenderArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.bounceSenderArn)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendBounceRequest.ReadOnly =
    zio.aws.ses.model.SendBounceRequest.wrap(buildAwsValue())
}
object SendBounceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendBounceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendBounceRequest =
      zio.aws.ses.model.SendBounceRequest(
        originalMessageId,
        bounceSender,
        explanation.map(value => value),
        messageDsn.map(value => value.asEditable),
        bouncedRecipientInfoList.map { item =>
          item.asEditable
        },
        bounceSenderArn.map(value => value)
      )
    def originalMessageId: MessageId
    def bounceSender: Address
    def explanation: Option[Explanation]
    def messageDsn: Option[zio.aws.ses.model.MessageDsn.ReadOnly]
    def bouncedRecipientInfoList
        : List[zio.aws.ses.model.BouncedRecipientInfo.ReadOnly]
    def bounceSenderArn: Option[AmazonResourceName]
    def getOriginalMessageId: ZIO[Any, Nothing, MessageId] =
      ZIO.succeed(originalMessageId)
    def getBounceSender: ZIO[Any, Nothing, Address] = ZIO.succeed(bounceSender)
    def getExplanation: ZIO[Any, AwsError, Explanation] =
      AwsError.unwrapOptionField("explanation", explanation)
    def getMessageDsn
        : ZIO[Any, AwsError, zio.aws.ses.model.MessageDsn.ReadOnly] =
      AwsError.unwrapOptionField("messageDsn", messageDsn)
    def getBouncedRecipientInfoList: ZIO[Any, Nothing, List[
      zio.aws.ses.model.BouncedRecipientInfo.ReadOnly
    ]] = ZIO.succeed(bouncedRecipientInfoList)
    def getBounceSenderArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("bounceSenderArn", bounceSenderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendBounceRequest
  ) extends zio.aws.ses.model.SendBounceRequest.ReadOnly {
    override val originalMessageId: MessageId =
      zio.aws.ses.model.primitives.MessageId(impl.originalMessageId())
    override val bounceSender: Address =
      zio.aws.ses.model.primitives.Address(impl.bounceSender())
    override val explanation: Option[Explanation] = scala
      .Option(impl.explanation())
      .map(value => zio.aws.ses.model.primitives.Explanation(value))
    override val messageDsn: Option[zio.aws.ses.model.MessageDsn.ReadOnly] =
      scala
        .Option(impl.messageDsn())
        .map(value => zio.aws.ses.model.MessageDsn.wrap(value))
    override val bouncedRecipientInfoList
        : List[zio.aws.ses.model.BouncedRecipientInfo.ReadOnly] = impl
      .bouncedRecipientInfoList()
      .asScala
      .map { item =>
        zio.aws.ses.model.BouncedRecipientInfo.wrap(item)
      }
      .toList
    override val bounceSenderArn: Option[AmazonResourceName] = scala
      .Option(impl.bounceSenderArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendBounceRequest
  ): zio.aws.ses.model.SendBounceRequest.ReadOnly = new Wrapper(impl)
}
