package zio.aws.ses.model
import zio.aws.ses.model.primitives.MessageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SendBounceResponse(messageId: Option[MessageId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendBounceResponse = {
    import SendBounceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendBounceResponse
      .builder()
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendBounceResponse.ReadOnly =
    zio.aws.ses.model.SendBounceResponse.wrap(buildAwsValue())
}
object SendBounceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendBounceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendBounceResponse =
      zio.aws.ses.model.SendBounceResponse(messageId.map(value => value))
    def messageId: Option[MessageId]
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendBounceResponse
  ) extends zio.aws.ses.model.SendBounceResponse.ReadOnly {
    override val messageId: Option[MessageId] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.ses.model.primitives.MessageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendBounceResponse
  ): zio.aws.ses.model.SendBounceResponse.ReadOnly = new Wrapper(impl)
}
