package zio.aws.ses.model
import zio.aws.ses.model.primitives.MessageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SendEmailResponse(messageId: MessageId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendEmailResponse = {
    import SendEmailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendEmailResponse
      .builder()
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendEmailResponse.ReadOnly =
    zio.aws.ses.model.SendEmailResponse.wrap(buildAwsValue())
}
object SendEmailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendEmailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendEmailResponse =
      zio.aws.ses.model.SendEmailResponse(messageId)
    def messageId: MessageId
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendEmailResponse
  ) extends zio.aws.ses.model.SendEmailResponse.ReadOnly {
    override val messageId: MessageId =
      zio.aws.ses.model.primitives.MessageId(impl.messageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendEmailResponse
  ): zio.aws.ses.model.SendEmailResponse.ReadOnly = new Wrapper(impl)
}
