package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  ConfigurationSetName,
  AmazonResourceName,
  Address
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SendRawEmailRequest(
    source: Option[Address] = None,
    destinations: Option[Iterable[Address]] = None,
    rawMessage: zio.aws.ses.model.RawMessage,
    fromArn: Option[AmazonResourceName] = None,
    sourceArn: Option[AmazonResourceName] = None,
    returnPathArn: Option[AmazonResourceName] = None,
    tags: Option[Iterable[zio.aws.ses.model.MessageTag]] = None,
    configurationSetName: Option[ConfigurationSetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendRawEmailRequest = {
    import SendRawEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendRawEmailRequest
      .builder()
      .optionallyWith(
        source.map(value => Address.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.destinations)
      .rawMessage(rawMessage.buildAwsValue())
      .optionallyWith(
        fromArn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.fromArn)
      .optionallyWith(
        sourceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(
        returnPathArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.returnPathArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendRawEmailRequest.ReadOnly =
    zio.aws.ses.model.SendRawEmailRequest.wrap(buildAwsValue())
}
object SendRawEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendRawEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendRawEmailRequest =
      zio.aws.ses.model.SendRawEmailRequest(
        source.map(value => value),
        destinations.map(value => value),
        rawMessage.asEditable,
        fromArn.map(value => value),
        sourceArn.map(value => value),
        returnPathArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationSetName.map(value => value)
      )
    def source: Option[Address]
    def destinations: Option[List[Address]]
    def rawMessage: zio.aws.ses.model.RawMessage.ReadOnly
    def fromArn: Option[AmazonResourceName]
    def sourceArn: Option[AmazonResourceName]
    def returnPathArn: Option[AmazonResourceName]
    def tags: Option[List[zio.aws.ses.model.MessageTag.ReadOnly]]
    def configurationSetName: Option[ConfigurationSetName]
    def getSource: ZIO[Any, AwsError, Address] =
      AwsError.unwrapOptionField("source", source)
    def getDestinations: ZIO[Any, AwsError, List[Address]] =
      AwsError.unwrapOptionField("destinations", destinations)
    def getRawMessage
        : ZIO[Any, Nothing, zio.aws.ses.model.RawMessage.ReadOnly] =
      ZIO.succeed(rawMessage)
    def getFromArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("fromArn", fromArn)
    def getSourceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getReturnPathArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("returnPathArn", returnPathArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendRawEmailRequest
  ) extends zio.aws.ses.model.SendRawEmailRequest.ReadOnly {
    override val source: Option[Address] = scala
      .Option(impl.source())
      .map(value => zio.aws.ses.model.primitives.Address(value))
    override val destinations: Option[List[Address]] = scala
      .Option(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.primitives.Address(item)
        }.toList
      )
    override val rawMessage: zio.aws.ses.model.RawMessage.ReadOnly =
      zio.aws.ses.model.RawMessage.wrap(impl.rawMessage())
    override val fromArn: Option[AmazonResourceName] = scala
      .Option(impl.fromArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val sourceArn: Option[AmazonResourceName] = scala
      .Option(impl.sourceArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val returnPathArn: Option[AmazonResourceName] = scala
      .Option(impl.returnPathArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val tags: Option[List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.MessageTag.wrap(item)
          }.toList
        )
    override val configurationSetName: Option[ConfigurationSetName] = scala
      .Option(impl.configurationSetName())
      .map(value => zio.aws.ses.model.primitives.ConfigurationSetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendRawEmailRequest
  ): zio.aws.ses.model.SendRawEmailRequest.ReadOnly = new Wrapper(impl)
}
