package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Enabled, Identity}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetIdentityHeadersInNotificationsEnabledRequest(
    identity: Identity,
    notificationType: zio.aws.ses.model.NotificationType,
    enabled: Enabled
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest = {
    import SetIdentityHeadersInNotificationsEnabledRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest
      .builder()
      .identity(Identity.unwrap(identity): java.lang.String)
      .notificationType(notificationType.unwrap)
      .enabled(Enabled.unwrap(enabled): java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledRequest.ReadOnly =
    zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledRequest
      .wrap(buildAwsValue())
}
object SetIdentityHeadersInNotificationsEnabledRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledRequest =
      zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledRequest(
        identity,
        notificationType,
        enabled
      )
    def identity: Identity
    def notificationType: zio.aws.ses.model.NotificationType
    def enabled: Enabled
    def getIdentity: ZIO[Any, Nothing, Identity] = ZIO.succeed(identity)
    def getNotificationType
        : ZIO[Any, Nothing, zio.aws.ses.model.NotificationType] =
      ZIO.succeed(notificationType)
    def getEnabled: ZIO[Any, Nothing, Enabled] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest
  ) extends zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledRequest.ReadOnly {
    override val identity: Identity =
      zio.aws.ses.model.primitives.Identity(impl.identity())
    override val notificationType: zio.aws.ses.model.NotificationType =
      zio.aws.ses.model.NotificationType.wrap(impl.notificationType())
    override val enabled: Enabled =
      zio.aws.ses.model.primitives.Enabled(impl.enabled())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest
  ): zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledRequest.ReadOnly =
    new Wrapper(impl)
}
