package zio.aws.ses.model
import zio.aws.ses.model.primitives.{MailFromDomainName, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SetIdentityMailFromDomainRequest(
    identity: Identity,
    mailFromDomain: Option[MailFromDomainName] = None,
    behaviorOnMXFailure: Option[zio.aws.ses.model.BehaviorOnMXFailure] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest = {
    import SetIdentityMailFromDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest
      .builder()
      .identity(Identity.unwrap(identity): java.lang.String)
      .optionallyWith(
        mailFromDomain.map(value =>
          MailFromDomainName.unwrap(value): java.lang.String
        )
      )(_.mailFromDomain)
      .optionallyWith(behaviorOnMXFailure.map(value => value.unwrap))(
        _.behaviorOnMXFailure
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SetIdentityMailFromDomainRequest.ReadOnly =
    zio.aws.ses.model.SetIdentityMailFromDomainRequest.wrap(buildAwsValue())
}
object SetIdentityMailFromDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SetIdentityMailFromDomainRequest =
      zio.aws.ses.model.SetIdentityMailFromDomainRequest(
        identity,
        mailFromDomain.map(value => value),
        behaviorOnMXFailure.map(value => value)
      )
    def identity: Identity
    def mailFromDomain: Option[MailFromDomainName]
    def behaviorOnMXFailure: Option[zio.aws.ses.model.BehaviorOnMXFailure]
    def getIdentity: ZIO[Any, Nothing, Identity] = ZIO.succeed(identity)
    def getMailFromDomain: ZIO[Any, AwsError, MailFromDomainName] =
      AwsError.unwrapOptionField("mailFromDomain", mailFromDomain)
    def getBehaviorOnMXFailure
        : ZIO[Any, AwsError, zio.aws.ses.model.BehaviorOnMXFailure] =
      AwsError.unwrapOptionField("behaviorOnMXFailure", behaviorOnMXFailure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest
  ) extends zio.aws.ses.model.SetIdentityMailFromDomainRequest.ReadOnly {
    override val identity: Identity =
      zio.aws.ses.model.primitives.Identity(impl.identity())
    override val mailFromDomain: Option[MailFromDomainName] = scala
      .Option(impl.mailFromDomain())
      .map(value => zio.aws.ses.model.primitives.MailFromDomainName(value))
    override val behaviorOnMXFailure
        : Option[zio.aws.ses.model.BehaviorOnMXFailure] = scala
      .Option(impl.behaviorOnMXFailure())
      .map(value => zio.aws.ses.model.BehaviorOnMXFailure.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest
  ): zio.aws.ses.model.SetIdentityMailFromDomainRequest.ReadOnly = new Wrapper(
    impl
  )
}
