package zio.aws.ses.model
import zio.aws.ses.model.primitives.{TemplateData, TemplateName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestRenderTemplateRequest(
    templateName: TemplateName,
    templateData: TemplateData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest = {
    import TestRenderTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .templateData(TemplateData.unwrap(templateData): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.TestRenderTemplateRequest.ReadOnly =
    zio.aws.ses.model.TestRenderTemplateRequest.wrap(buildAwsValue())
}
object TestRenderTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.TestRenderTemplateRequest =
      zio.aws.ses.model.TestRenderTemplateRequest(templateName, templateData)
    def templateName: TemplateName
    def templateData: TemplateData
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getTemplateData: ZIO[Any, Nothing, TemplateData] =
      ZIO.succeed(templateData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest
  ) extends zio.aws.ses.model.TestRenderTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.templateName())
    override val templateData: TemplateData =
      zio.aws.ses.model.primitives.TemplateData(impl.templateData())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest
  ): zio.aws.ses.model.TestRenderTemplateRequest.ReadOnly = new Wrapper(impl)
}
