package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Enabled, ConfigurationSetName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationSetReputationMetricsEnabledRequest(
    configurationSetName: ConfigurationSetName,
    enabled: Enabled
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest = {
    import UpdateConfigurationSetReputationMetricsEnabledRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .enabled(Enabled.unwrap(enabled): java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest.ReadOnly =
    zio.aws.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest
      .wrap(buildAwsValue())
}
object UpdateConfigurationSetReputationMetricsEnabledRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest =
      zio.aws.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest(
        configurationSetName,
        enabled
      )
    def configurationSetName: ConfigurationSetName
    def enabled: Enabled
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getEnabled: ZIO[Any, Nothing, Enabled] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest
  ) extends zio.aws.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.ses.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val enabled: Enabled =
      zio.aws.ses.model.primitives.Enabled(impl.enabled())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest
  ): zio.aws.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest.ReadOnly =
    new Wrapper(impl)
}
