package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  TemplateName,
  FromAddress,
  TemplateContent,
  FailureRedirectionURL,
  SuccessRedirectionURL,
  Subject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateCustomVerificationEmailTemplateRequest(
    templateName: TemplateName,
    fromEmailAddress: Option[FromAddress] = None,
    templateSubject: Option[Subject] = None,
    templateContent: Option[TemplateContent] = None,
    successRedirectionURL: Option[SuccessRedirectionURL] = None,
    failureRedirectionURL: Option[FailureRedirectionURL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest = {
    import UpdateCustomVerificationEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .optionallyWith(
        fromEmailAddress.map(value =>
          FromAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        templateSubject.map(value => Subject.unwrap(value): java.lang.String)
      )(_.templateSubject)
      .optionallyWith(
        templateContent.map(value =>
          TemplateContent.unwrap(value): java.lang.String
        )
      )(_.templateContent)
      .optionallyWith(
        successRedirectionURL.map(value =>
          SuccessRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.successRedirectionURL)
      .optionallyWith(
        failureRedirectionURL.map(value =>
          FailureRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.failureRedirectionURL)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest.ReadOnly =
    zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest
      .wrap(buildAwsValue())
}
object UpdateCustomVerificationEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest =
      zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest(
        templateName,
        fromEmailAddress.map(value => value),
        templateSubject.map(value => value),
        templateContent.map(value => value),
        successRedirectionURL.map(value => value),
        failureRedirectionURL.map(value => value)
      )
    def templateName: TemplateName
    def fromEmailAddress: Option[FromAddress]
    def templateSubject: Option[Subject]
    def templateContent: Option[TemplateContent]
    def successRedirectionURL: Option[SuccessRedirectionURL]
    def failureRedirectionURL: Option[FailureRedirectionURL]
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getFromEmailAddress: ZIO[Any, AwsError, FromAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getTemplateSubject: ZIO[Any, AwsError, Subject] =
      AwsError.unwrapOptionField("templateSubject", templateSubject)
    def getTemplateContent: ZIO[Any, AwsError, TemplateContent] =
      AwsError.unwrapOptionField("templateContent", templateContent)
    def getSuccessRedirectionURL: ZIO[Any, AwsError, SuccessRedirectionURL] =
      AwsError.unwrapOptionField("successRedirectionURL", successRedirectionURL)
    def getFailureRedirectionURL: ZIO[Any, AwsError, FailureRedirectionURL] =
      AwsError.unwrapOptionField("failureRedirectionURL", failureRedirectionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest
  ) extends zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.templateName())
    override val fromEmailAddress: Option[FromAddress] = scala
      .Option(impl.fromEmailAddress())
      .map(value => zio.aws.ses.model.primitives.FromAddress(value))
    override val templateSubject: Option[Subject] = scala
      .Option(impl.templateSubject())
      .map(value => zio.aws.ses.model.primitives.Subject(value))
    override val templateContent: Option[TemplateContent] = scala
      .Option(impl.templateContent())
      .map(value => zio.aws.ses.model.primitives.TemplateContent(value))
    override val successRedirectionURL: Option[SuccessRedirectionURL] = scala
      .Option(impl.successRedirectionURL())
      .map(value => zio.aws.ses.model.primitives.SuccessRedirectionURL(value))
    override val failureRedirectionURL: Option[FailureRedirectionURL] = scala
      .Option(impl.failureRedirectionURL())
      .map(value => zio.aws.ses.model.primitives.FailureRedirectionURL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest
  ): zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
