package zio.aws.ses.model
import zio.aws.ses.model.primitives.Address
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VerifyEmailAddressRequest(emailAddress: Address) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest = {
    import VerifyEmailAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest
      .builder()
      .emailAddress(Address.unwrap(emailAddress): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.VerifyEmailAddressRequest.ReadOnly =
    zio.aws.ses.model.VerifyEmailAddressRequest.wrap(buildAwsValue())
}
object VerifyEmailAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.VerifyEmailAddressRequest =
      zio.aws.ses.model.VerifyEmailAddressRequest(emailAddress)
    def emailAddress: Address
    def getEmailAddress: ZIO[Any, Nothing, Address] = ZIO.succeed(emailAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest
  ) extends zio.aws.ses.model.VerifyEmailAddressRequest.ReadOnly {
    override val emailAddress: Address =
      zio.aws.ses.model.primitives.Address(impl.emailAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest
  ): zio.aws.ses.model.VerifyEmailAddressRequest.ReadOnly = new Wrapper(impl)
}
