package zio.aws.ses.model
import zio.aws.ses.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class WorkmailAction(
    topicArn: Option[AmazonResourceName] = None,
    organizationArn: AmazonResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.WorkmailAction = {
    import WorkmailAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.WorkmailAction
      .builder()
      .optionallyWith(
        topicArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.topicArn)
      .organizationArn(
        AmazonResourceName.unwrap(organizationArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.WorkmailAction.ReadOnly =
    zio.aws.ses.model.WorkmailAction.wrap(buildAwsValue())
}
object WorkmailAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.WorkmailAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.WorkmailAction = zio.aws.ses.model
      .WorkmailAction(topicArn.map(value => value), organizationArn)
    def topicArn: Option[AmazonResourceName]
    def organizationArn: AmazonResourceName
    def getTopicArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getOrganizationArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(organizationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.WorkmailAction
  ) extends zio.aws.ses.model.WorkmailAction.ReadOnly {
    override val topicArn: Option[AmazonResourceName] = scala
      .Option(impl.topicArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val organizationArn: AmazonResourceName =
      zio.aws.ses.model.primitives.AmazonResourceName(impl.organizationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.WorkmailAction
  ): zio.aws.ses.model.WorkmailAction.ReadOnly = new Wrapper(impl)
}
