package zio.aws.ses.model
import zio.aws.ses.model.primitives.{HeaderValue, HeaderName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddHeaderAction(
    headerName: HeaderName,
    headerValue: HeaderValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.AddHeaderAction = {
    import AddHeaderAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.AddHeaderAction
      .builder()
      .headerName(HeaderName.unwrap(headerName): java.lang.String)
      .headerValue(HeaderValue.unwrap(headerValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.AddHeaderAction.ReadOnly =
    zio.aws.ses.model.AddHeaderAction.wrap(buildAwsValue())
}
object AddHeaderAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.AddHeaderAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.AddHeaderAction =
      zio.aws.ses.model.AddHeaderAction(headerName, headerValue)
    def headerName: HeaderName
    def headerValue: HeaderValue
    def getHeaderName: ZIO[Any, Nothing, HeaderName] = ZIO.succeed(headerName)
    def getHeaderValue: ZIO[Any, Nothing, HeaderValue] =
      ZIO.succeed(headerValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.AddHeaderAction
  ) extends zio.aws.ses.model.AddHeaderAction.ReadOnly {
    override val headerName: HeaderName =
      zio.aws.ses.model.primitives.HeaderName(impl.headerName())
    override val headerValue: HeaderValue =
      zio.aws.ses.model.primitives.HeaderValue(impl.headerValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.AddHeaderAction
  ): zio.aws.ses.model.AddHeaderAction.ReadOnly = new Wrapper(impl)
}
