package zio.aws.ses.model
import zio.aws.ses.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ConfigurationSet(name: ConfigurationSetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ConfigurationSet = {
    import ConfigurationSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ConfigurationSet
      .builder()
      .name(ConfigurationSetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ConfigurationSet.ReadOnly =
    zio.aws.ses.model.ConfigurationSet.wrap(buildAwsValue())
}
object ConfigurationSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ConfigurationSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ConfigurationSet =
      zio.aws.ses.model.ConfigurationSet(name)
    def name: ConfigurationSetName
    def getName: ZIO[Any, Nothing, ConfigurationSetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ConfigurationSet
  ) extends zio.aws.ses.model.ConfigurationSet.ReadOnly {
    override val name: ConfigurationSetName =
      zio.aws.ses.model.primitives.ConfigurationSetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ConfigurationSet
  ): zio.aws.ses.model.ConfigurationSet.ReadOnly = new Wrapper(impl)
}
