package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  TemplateName,
  FromAddress,
  TemplateContent,
  FailureRedirectionURL,
  SuccessRedirectionURL,
  Subject
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateCustomVerificationEmailTemplateRequest(
    templateName: TemplateName,
    fromEmailAddress: FromAddress,
    templateSubject: Subject,
    templateContent: TemplateContent,
    successRedirectionURL: SuccessRedirectionURL,
    failureRedirectionURL: FailureRedirectionURL
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest = {
    import CreateCustomVerificationEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .fromEmailAddress(FromAddress.unwrap(fromEmailAddress): java.lang.String)
      .templateSubject(Subject.unwrap(templateSubject): java.lang.String)
      .templateContent(
        TemplateContent.unwrap(templateContent): java.lang.String
      )
      .successRedirectionURL(
        SuccessRedirectionURL.unwrap(successRedirectionURL): java.lang.String
      )
      .failureRedirectionURL(
        FailureRedirectionURL.unwrap(failureRedirectionURL): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.CreateCustomVerificationEmailTemplateRequest.ReadOnly =
    zio.aws.ses.model.CreateCustomVerificationEmailTemplateRequest
      .wrap(buildAwsValue())
}
object CreateCustomVerificationEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.CreateCustomVerificationEmailTemplateRequest =
      zio.aws.ses.model.CreateCustomVerificationEmailTemplateRequest(
        templateName,
        fromEmailAddress,
        templateSubject,
        templateContent,
        successRedirectionURL,
        failureRedirectionURL
      )
    def templateName: TemplateName
    def fromEmailAddress: FromAddress
    def templateSubject: Subject
    def templateContent: TemplateContent
    def successRedirectionURL: SuccessRedirectionURL
    def failureRedirectionURL: FailureRedirectionURL
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getFromEmailAddress: ZIO[Any, Nothing, FromAddress] =
      ZIO.succeed(fromEmailAddress)
    def getTemplateSubject: ZIO[Any, Nothing, Subject] =
      ZIO.succeed(templateSubject)
    def getTemplateContent: ZIO[Any, Nothing, TemplateContent] =
      ZIO.succeed(templateContent)
    def getSuccessRedirectionURL: ZIO[Any, Nothing, SuccessRedirectionURL] =
      ZIO.succeed(successRedirectionURL)
    def getFailureRedirectionURL: ZIO[Any, Nothing, FailureRedirectionURL] =
      ZIO.succeed(failureRedirectionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest
  ) extends zio.aws.ses.model.CreateCustomVerificationEmailTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.templateName())
    override val fromEmailAddress: FromAddress =
      zio.aws.ses.model.primitives.FromAddress(impl.fromEmailAddress())
    override val templateSubject: Subject =
      zio.aws.ses.model.primitives.Subject(impl.templateSubject())
    override val templateContent: TemplateContent =
      zio.aws.ses.model.primitives.TemplateContent(impl.templateContent())
    override val successRedirectionURL: SuccessRedirectionURL =
      zio.aws.ses.model.primitives
        .SuccessRedirectionURL(impl.successRedirectionURL())
    override val failureRedirectionURL: FailureRedirectionURL =
      zio.aws.ses.model.primitives
        .FailureRedirectionURL(impl.failureRedirectionURL())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest
  ): zio.aws.ses.model.CreateCustomVerificationEmailTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
