package zio.aws.ses.model
import zio.aws.ses.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteConfigurationSetTrackingOptionsRequest(
    configurationSetName: ConfigurationSetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest = {
    import DeleteConfigurationSetTrackingOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsRequest.ReadOnly =
    zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsRequest
      .wrap(buildAwsValue())
}
object DeleteConfigurationSetTrackingOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsRequest =
      zio.aws.ses.model
        .DeleteConfigurationSetTrackingOptionsRequest(configurationSetName)
    def configurationSetName: ConfigurationSetName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest
  ) extends zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.ses.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest
  ): zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
