package zio.aws.ses.model
import zio.aws.ses.model.primitives.{PolicyName, Identity}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteIdentityPolicyRequest(
    identity: Identity,
    policyName: PolicyName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest = {
    import DeleteIdentityPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest
      .builder()
      .identity(Identity.unwrap(identity): java.lang.String)
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DeleteIdentityPolicyRequest.ReadOnly =
    zio.aws.ses.model.DeleteIdentityPolicyRequest.wrap(buildAwsValue())
}
object DeleteIdentityPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DeleteIdentityPolicyRequest =
      zio.aws.ses.model.DeleteIdentityPolicyRequest(identity, policyName)
    def identity: Identity
    def policyName: PolicyName
    def getIdentity: ZIO[Any, Nothing, Identity] = ZIO.succeed(identity)
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest
  ) extends zio.aws.ses.model.DeleteIdentityPolicyRequest.ReadOnly {
    override val identity: Identity =
      zio.aws.ses.model.primitives.Identity(impl.identity())
    override val policyName: PolicyName =
      zio.aws.ses.model.primitives.PolicyName(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest
  ): zio.aws.ses.model.DeleteIdentityPolicyRequest.ReadOnly = new Wrapper(impl)
}
