package zio.aws.ses.model
import zio.aws.ses.model.primitives.TemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTemplateRequest(templateName: TemplateName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteTemplateRequest = {
    import DeleteTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DeleteTemplateRequest.ReadOnly =
    zio.aws.ses.model.DeleteTemplateRequest.wrap(buildAwsValue())
}
object DeleteTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DeleteTemplateRequest =
      zio.aws.ses.model.DeleteTemplateRequest(templateName)
    def templateName: TemplateName
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteTemplateRequest
  ) extends zio.aws.ses.model.DeleteTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteTemplateRequest
  ): zio.aws.ses.model.DeleteTemplateRequest.ReadOnly = new Wrapper(impl)
}
