package zio.aws.ses.model
import zio.aws.ses.model.primitives.Address
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteVerifiedEmailAddressRequest(emailAddress: Address) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest = {
    import DeleteVerifiedEmailAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest
      .builder()
      .emailAddress(Address.unwrap(emailAddress): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DeleteVerifiedEmailAddressRequest.ReadOnly =
    zio.aws.ses.model.DeleteVerifiedEmailAddressRequest.wrap(buildAwsValue())
}
object DeleteVerifiedEmailAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DeleteVerifiedEmailAddressRequest =
      zio.aws.ses.model.DeleteVerifiedEmailAddressRequest(emailAddress)
    def emailAddress: Address
    def getEmailAddress: ZIO[Any, Nothing, Address] = ZIO.succeed(emailAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest
  ) extends zio.aws.ses.model.DeleteVerifiedEmailAddressRequest.ReadOnly {
    override val emailAddress: Address =
      zio.aws.ses.model.primitives.Address(impl.emailAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest
  ): zio.aws.ses.model.DeleteVerifiedEmailAddressRequest.ReadOnly = new Wrapper(
    impl
  )
}
