package zio.aws.ses.model
import zio.aws.ses.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationSetRequest(
    configurationSetName: ConfigurationSetName,
    configurationSetAttributeNames: Optional[
      Iterable[zio.aws.ses.model.ConfigurationSetAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest = {
    import DescribeConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(
        configurationSetAttributeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.configurationSetAttributeNamesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DescribeConfigurationSetRequest.ReadOnly =
    zio.aws.ses.model.DescribeConfigurationSetRequest.wrap(buildAwsValue())
}
object DescribeConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DescribeConfigurationSetRequest =
      zio.aws.ses.model.DescribeConfigurationSetRequest(
        configurationSetName,
        configurationSetAttributeNames.map(value => value)
      )
    def configurationSetName: ConfigurationSetName
    def configurationSetAttributeNames
        : Optional[List[zio.aws.ses.model.ConfigurationSetAttribute]]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getConfigurationSetAttributeNames: ZIO[Any, AwsError, List[
      zio.aws.ses.model.ConfigurationSetAttribute
    ]] = AwsError.unwrapOptionField(
      "configurationSetAttributeNames",
      configurationSetAttributeNames
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest
  ) extends zio.aws.ses.model.DescribeConfigurationSetRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.ses.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val configurationSetAttributeNames
        : Optional[List[zio.aws.ses.model.ConfigurationSetAttribute]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetAttributeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.ConfigurationSetAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest
  ): zio.aws.ses.model.DescribeConfigurationSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
