package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationSetResponse(
    configurationSet: Optional[zio.aws.ses.model.ConfigurationSet] =
      Optional.Absent,
    eventDestinations: Optional[Iterable[zio.aws.ses.model.EventDestination]] =
      Optional.Absent,
    trackingOptions: Optional[zio.aws.ses.model.TrackingOptions] =
      Optional.Absent,
    deliveryOptions: Optional[zio.aws.ses.model.DeliveryOptions] =
      Optional.Absent,
    reputationOptions: Optional[zio.aws.ses.model.ReputationOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DescribeConfigurationSetResponse = {
    import DescribeConfigurationSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DescribeConfigurationSetResponse
      .builder()
      .optionallyWith(configurationSet.map(value => value.buildAwsValue()))(
        _.configurationSet
      )
      .optionallyWith(
        eventDestinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventDestinations)
      .optionallyWith(trackingOptions.map(value => value.buildAwsValue()))(
        _.trackingOptions
      )
      .optionallyWith(deliveryOptions.map(value => value.buildAwsValue()))(
        _.deliveryOptions
      )
      .optionallyWith(reputationOptions.map(value => value.buildAwsValue()))(
        _.reputationOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DescribeConfigurationSetResponse.ReadOnly =
    zio.aws.ses.model.DescribeConfigurationSetResponse.wrap(buildAwsValue())
}
object DescribeConfigurationSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DescribeConfigurationSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DescribeConfigurationSetResponse =
      zio.aws.ses.model.DescribeConfigurationSetResponse(
        configurationSet.map(value => value.asEditable),
        eventDestinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        trackingOptions.map(value => value.asEditable),
        deliveryOptions.map(value => value.asEditable),
        reputationOptions.map(value => value.asEditable)
      )
    def configurationSet: Optional[zio.aws.ses.model.ConfigurationSet.ReadOnly]
    def eventDestinations
        : Optional[List[zio.aws.ses.model.EventDestination.ReadOnly]]
    def trackingOptions: Optional[zio.aws.ses.model.TrackingOptions.ReadOnly]
    def deliveryOptions: Optional[zio.aws.ses.model.DeliveryOptions.ReadOnly]
    def reputationOptions
        : Optional[zio.aws.ses.model.ReputationOptions.ReadOnly]
    def getConfigurationSet
        : ZIO[Any, AwsError, zio.aws.ses.model.ConfigurationSet.ReadOnly] =
      AwsError.unwrapOptionField("configurationSet", configurationSet)
    def getEventDestinations: ZIO[Any, AwsError, List[
      zio.aws.ses.model.EventDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("eventDestinations", eventDestinations)
    def getTrackingOptions
        : ZIO[Any, AwsError, zio.aws.ses.model.TrackingOptions.ReadOnly] =
      AwsError.unwrapOptionField("trackingOptions", trackingOptions)
    def getDeliveryOptions
        : ZIO[Any, AwsError, zio.aws.ses.model.DeliveryOptions.ReadOnly] =
      AwsError.unwrapOptionField("deliveryOptions", deliveryOptions)
    def getReputationOptions
        : ZIO[Any, AwsError, zio.aws.ses.model.ReputationOptions.ReadOnly] =
      AwsError.unwrapOptionField("reputationOptions", reputationOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DescribeConfigurationSetResponse
  ) extends zio.aws.ses.model.DescribeConfigurationSetResponse.ReadOnly {
    override val configurationSet
        : Optional[zio.aws.ses.model.ConfigurationSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSet())
        .map(value => zio.aws.ses.model.ConfigurationSet.wrap(value))
    override val eventDestinations
        : Optional[List[zio.aws.ses.model.EventDestination.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.EventDestination.wrap(item)
          }.toList
        )
    override val trackingOptions
        : Optional[zio.aws.ses.model.TrackingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trackingOptions())
        .map(value => zio.aws.ses.model.TrackingOptions.wrap(value))
    override val deliveryOptions
        : Optional[zio.aws.ses.model.DeliveryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryOptions())
        .map(value => zio.aws.ses.model.DeliveryOptions.wrap(value))
    override val reputationOptions
        : Optional[zio.aws.ses.model.ReputationOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reputationOptions())
        .map(value => zio.aws.ses.model.ReputationOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DescribeConfigurationSetResponse
  ): zio.aws.ses.model.DescribeConfigurationSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
