package zio.aws.ses.model
import zio.aws.ses.model.primitives.ReceiptRuleSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeReceiptRuleSetRequest(
    ruleSetName: ReceiptRuleSetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetRequest = {
    import DescribeReceiptRuleSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetRequest
      .builder()
      .ruleSetName(ReceiptRuleSetName.unwrap(ruleSetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DescribeReceiptRuleSetRequest.ReadOnly =
    zio.aws.ses.model.DescribeReceiptRuleSetRequest.wrap(buildAwsValue())
}
object DescribeReceiptRuleSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DescribeReceiptRuleSetRequest =
      zio.aws.ses.model.DescribeReceiptRuleSetRequest(ruleSetName)
    def ruleSetName: ReceiptRuleSetName
    def getRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(ruleSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetRequest
  ) extends zio.aws.ses.model.DescribeReceiptRuleSetRequest.ReadOnly {
    override val ruleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName(impl.ruleSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetRequest
  ): zio.aws.ses.model.DescribeReceiptRuleSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
