package zio.aws.ses.model
import zio.aws.ses.model.primitives.Address
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Destination(
    toAddresses: Optional[Iterable[Address]] = Optional.Absent,
    ccAddresses: Optional[Iterable[Address]] = Optional.Absent,
    bccAddresses: Optional[Iterable[Address]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.Destination = {
    import Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.Destination
      .builder()
      .optionallyWith(
        toAddresses.map(value =>
          value.map { item =>
            Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.toAddresses)
      .optionallyWith(
        ccAddresses.map(value =>
          value.map { item =>
            Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ccAddresses)
      .optionallyWith(
        bccAddresses.map(value =>
          value.map { item =>
            Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bccAddresses)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.Destination.ReadOnly =
    zio.aws.ses.model.Destination.wrap(buildAwsValue())
}
object Destination {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.Destination] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.Destination =
      zio.aws.ses.model.Destination(
        toAddresses.map(value => value),
        ccAddresses.map(value => value),
        bccAddresses.map(value => value)
      )
    def toAddresses: Optional[List[Address]]
    def ccAddresses: Optional[List[Address]]
    def bccAddresses: Optional[List[Address]]
    def getToAddresses: ZIO[Any, AwsError, List[Address]] =
      AwsError.unwrapOptionField("toAddresses", toAddresses)
    def getCcAddresses: ZIO[Any, AwsError, List[Address]] =
      AwsError.unwrapOptionField("ccAddresses", ccAddresses)
    def getBccAddresses: ZIO[Any, AwsError, List[Address]] =
      AwsError.unwrapOptionField("bccAddresses", bccAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.Destination
  ) extends zio.aws.ses.model.Destination.ReadOnly {
    override val toAddresses: Optional[List[Address]] = zio.aws.core.internal
      .optionalFromNullable(impl.toAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.primitives.Address(item)
        }.toList
      )
    override val ccAddresses: Optional[List[Address]] = zio.aws.core.internal
      .optionalFromNullable(impl.ccAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.primitives.Address(item)
        }.toList
      )
    override val bccAddresses: Optional[List[Address]] = zio.aws.core.internal
      .optionalFromNullable(impl.bccAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.primitives.Address(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.Destination
  ): zio.aws.ses.model.Destination.ReadOnly = new Wrapper(impl)
}
