package zio.aws.ses.model
import zio.aws.ses.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetIdentityDkimAttributesRequest(
    identities: Iterable[Identity]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest = {
    import GetIdentityDkimAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest
      .builder()
      .identities(identities.map { item =>
        Identity.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.GetIdentityDkimAttributesRequest.ReadOnly =
    zio.aws.ses.model.GetIdentityDkimAttributesRequest.wrap(buildAwsValue())
}
object GetIdentityDkimAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetIdentityDkimAttributesRequest =
      zio.aws.ses.model.GetIdentityDkimAttributesRequest(identities)
    def identities: List[Identity]
    def getIdentities: ZIO[Any, Nothing, List[Identity]] =
      ZIO.succeed(identities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest
  ) extends zio.aws.ses.model.GetIdentityDkimAttributesRequest.ReadOnly {
    override val identities: List[Identity] = impl
      .identities()
      .asScala
      .map { item =>
        zio.aws.ses.model.primitives.Identity(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest
  ): zio.aws.ses.model.GetIdentityDkimAttributesRequest.ReadOnly = new Wrapper(
    impl
  )
}
