package zio.aws.ses.model
import zio.aws.ses.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetIdentityMailFromDomainAttributesResponse(
    mailFromDomainAttributes: Map[
      Identity,
      zio.aws.ses.model.IdentityMailFromDomainAttributes
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesResponse = {
    import GetIdentityMailFromDomainAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesResponse
      .builder()
      .mailFromDomainAttributes(
        mailFromDomainAttributes
          .map({ case (key, value) =>
            (Identity.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.GetIdentityMailFromDomainAttributesResponse.ReadOnly =
    zio.aws.ses.model.GetIdentityMailFromDomainAttributesResponse
      .wrap(buildAwsValue())
}
object GetIdentityMailFromDomainAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.GetIdentityMailFromDomainAttributesResponse =
      zio.aws.ses.model.GetIdentityMailFromDomainAttributesResponse(
        mailFromDomainAttributes.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def mailFromDomainAttributes: Map[
      Identity,
      zio.aws.ses.model.IdentityMailFromDomainAttributes.ReadOnly
    ]
    def getMailFromDomainAttributes: ZIO[Any, Nothing, Map[
      Identity,
      zio.aws.ses.model.IdentityMailFromDomainAttributes.ReadOnly
    ]] = ZIO.succeed(mailFromDomainAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesResponse
  ) extends zio.aws.ses.model.GetIdentityMailFromDomainAttributesResponse.ReadOnly {
    override val mailFromDomainAttributes: Map[
      Identity,
      zio.aws.ses.model.IdentityMailFromDomainAttributes.ReadOnly
    ] = impl
      .mailFromDomainAttributes()
      .asScala
      .map({ case (key, value) =>
        zio.aws.ses.model.primitives.Identity(
          key
        ) -> zio.aws.ses.model.IdentityMailFromDomainAttributes.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesResponse
  ): zio.aws.ses.model.GetIdentityMailFromDomainAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
