package zio.aws.ses.model
import zio.aws.ses.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetIdentityNotificationAttributesResponse(
    notificationAttributes: Map[
      Identity,
      zio.aws.ses.model.IdentityNotificationAttributes
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesResponse = {
    import GetIdentityNotificationAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesResponse
      .builder()
      .notificationAttributes(
        notificationAttributes
          .map({ case (key, value) =>
            (Identity.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.GetIdentityNotificationAttributesResponse.ReadOnly =
    zio.aws.ses.model.GetIdentityNotificationAttributesResponse
      .wrap(buildAwsValue())
}
object GetIdentityNotificationAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.GetIdentityNotificationAttributesResponse =
      zio.aws.ses.model
        .GetIdentityNotificationAttributesResponse(notificationAttributes.map({
          case (key, value) =>
            key -> value.asEditable
        }))
    def notificationAttributes: Map[
      Identity,
      zio.aws.ses.model.IdentityNotificationAttributes.ReadOnly
    ]
    def getNotificationAttributes: ZIO[Any, Nothing, Map[
      Identity,
      zio.aws.ses.model.IdentityNotificationAttributes.ReadOnly
    ]] = ZIO.succeed(notificationAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesResponse
  ) extends zio.aws.ses.model.GetIdentityNotificationAttributesResponse.ReadOnly {
    override val notificationAttributes: Map[
      Identity,
      zio.aws.ses.model.IdentityNotificationAttributes.ReadOnly
    ] = impl
      .notificationAttributes()
      .asScala
      .map({ case (key, value) =>
        zio.aws.ses.model.primitives.Identity(
          key
        ) -> zio.aws.ses.model.IdentityNotificationAttributes.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesResponse
  ): zio.aws.ses.model.GetIdentityNotificationAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
