package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Policy, PolicyName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetIdentityPoliciesResponse(
    policies: Map[PolicyName, Policy]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetIdentityPoliciesResponse = {
    import GetIdentityPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetIdentityPoliciesResponse
      .builder()
      .policies(
        policies
          .map({ case (key, value) =>
            (PolicyName.unwrap(key): java.lang.String) -> (Policy
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.GetIdentityPoliciesResponse.ReadOnly =
    zio.aws.ses.model.GetIdentityPoliciesResponse.wrap(buildAwsValue())
}
object GetIdentityPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetIdentityPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetIdentityPoliciesResponse =
      zio.aws.ses.model.GetIdentityPoliciesResponse(policies)
    def policies: Map[PolicyName, Policy]
    def getPolicies: ZIO[Any, Nothing, Map[PolicyName, Policy]] =
      ZIO.succeed(policies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityPoliciesResponse
  ) extends zio.aws.ses.model.GetIdentityPoliciesResponse.ReadOnly {
    override val policies: Map[PolicyName, Policy] = impl
      .policies()
      .asScala
      .map({ case (key, value) =>
        zio.aws.ses.model.primitives
          .PolicyName(key) -> zio.aws.ses.model.primitives.Policy(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityPoliciesResponse
  ): zio.aws.ses.model.GetIdentityPoliciesResponse.ReadOnly = new Wrapper(impl)
}
