package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  SentLast24Hours,
  MaxSendRate,
  Max24HourSend
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSendQuotaResponse(
    max24HourSend: Optional[Max24HourSend] = Optional.Absent,
    maxSendRate: Optional[MaxSendRate] = Optional.Absent,
    sentLast24Hours: Optional[SentLast24Hours] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetSendQuotaResponse = {
    import GetSendQuotaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetSendQuotaResponse
      .builder()
      .optionallyWith(
        max24HourSend.map(value =>
          Max24HourSend.unwrap(value): java.lang.Double
        )
      )(_.max24HourSend)
      .optionallyWith(
        maxSendRate.map(value => MaxSendRate.unwrap(value): java.lang.Double)
      )(_.maxSendRate)
      .optionallyWith(
        sentLast24Hours.map(value =>
          SentLast24Hours.unwrap(value): java.lang.Double
        )
      )(_.sentLast24Hours)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.GetSendQuotaResponse.ReadOnly =
    zio.aws.ses.model.GetSendQuotaResponse.wrap(buildAwsValue())
}
object GetSendQuotaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetSendQuotaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetSendQuotaResponse =
      zio.aws.ses.model.GetSendQuotaResponse(
        max24HourSend.map(value => value),
        maxSendRate.map(value => value),
        sentLast24Hours.map(value => value)
      )
    def max24HourSend: Optional[Max24HourSend]
    def maxSendRate: Optional[MaxSendRate]
    def sentLast24Hours: Optional[SentLast24Hours]
    def getMax24HourSend: ZIO[Any, AwsError, Max24HourSend] =
      AwsError.unwrapOptionField("max24HourSend", max24HourSend)
    def getMaxSendRate: ZIO[Any, AwsError, MaxSendRate] =
      AwsError.unwrapOptionField("maxSendRate", maxSendRate)
    def getSentLast24Hours: ZIO[Any, AwsError, SentLast24Hours] =
      AwsError.unwrapOptionField("sentLast24Hours", sentLast24Hours)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetSendQuotaResponse
  ) extends zio.aws.ses.model.GetSendQuotaResponse.ReadOnly {
    override val max24HourSend: Optional[Max24HourSend] = zio.aws.core.internal
      .optionalFromNullable(impl.max24HourSend())
      .map(value => zio.aws.ses.model.primitives.Max24HourSend(value))
    override val maxSendRate: Optional[MaxSendRate] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSendRate())
      .map(value => zio.aws.ses.model.primitives.MaxSendRate(value))
    override val sentLast24Hours: Optional[SentLast24Hours] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sentLast24Hours())
        .map(value => zio.aws.ses.model.primitives.SentLast24Hours(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetSendQuotaResponse
  ): zio.aws.ses.model.GetSendQuotaResponse.ReadOnly = new Wrapper(impl)
}
