package zio.aws.ses.model
import zio.aws.ses.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KinesisFirehoseDestination(
    iamRoleARN: AmazonResourceName,
    deliveryStreamARN: AmazonResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.KinesisFirehoseDestination = {
    import KinesisFirehoseDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.KinesisFirehoseDestination
      .builder()
      .iamRoleARN(AmazonResourceName.unwrap(iamRoleARN): java.lang.String)
      .deliveryStreamARN(
        AmazonResourceName.unwrap(deliveryStreamARN): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.KinesisFirehoseDestination.ReadOnly =
    zio.aws.ses.model.KinesisFirehoseDestination.wrap(buildAwsValue())
}
object KinesisFirehoseDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.KinesisFirehoseDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.KinesisFirehoseDestination =
      zio.aws.ses.model
        .KinesisFirehoseDestination(iamRoleARN, deliveryStreamARN)
    def iamRoleARN: AmazonResourceName
    def deliveryStreamARN: AmazonResourceName
    def getIamRoleARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(iamRoleARN)
    def getDeliveryStreamARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(deliveryStreamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.KinesisFirehoseDestination
  ) extends zio.aws.ses.model.KinesisFirehoseDestination.ReadOnly {
    override val iamRoleARN: AmazonResourceName =
      zio.aws.ses.model.primitives.AmazonResourceName(impl.iamRoleARN())
    override val deliveryStreamARN: AmazonResourceName =
      zio.aws.ses.model.primitives.AmazonResourceName(impl.deliveryStreamARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.KinesisFirehoseDestination
  ): zio.aws.ses.model.KinesisFirehoseDestination.ReadOnly = new Wrapper(impl)
}
