package zio.aws.ses.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ses.model.primitives.{MaxItems, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListConfigurationSetsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxItems: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest = {
    import ListConfigurationSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListConfigurationSetsRequest.ReadOnly =
    zio.aws.ses.model.ListConfigurationSetsRequest.wrap(buildAwsValue())
}
object ListConfigurationSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListConfigurationSetsRequest =
      zio.aws.ses.model.ListConfigurationSetsRequest(
        nextToken.map(value => value),
        maxItems.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxItems: Optional[MaxItems]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest
  ) extends zio.aws.ses.model.ListConfigurationSetsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
    override val maxItems: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.ses.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest
  ): zio.aws.ses.model.ListConfigurationSetsRequest.ReadOnly = new Wrapper(impl)
}
