package zio.aws.ses.model
import zio.aws.ses.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCustomVerificationEmailTemplatesResponse(
    customVerificationEmailTemplates: Optional[
      Iterable[zio.aws.ses.model.CustomVerificationEmailTemplate]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse = {
    import ListCustomVerificationEmailTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse
      .builder()
      .optionallyWith(
        customVerificationEmailTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customVerificationEmailTemplates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly =
    zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse
      .wrap(buildAwsValue())
}
object ListCustomVerificationEmailTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse =
      zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse(
        customVerificationEmailTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def customVerificationEmailTemplates: Optional[
      List[zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getCustomVerificationEmailTemplates: ZIO[Any, AwsError, List[
      zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customVerificationEmailTemplates",
      customVerificationEmailTemplates
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse
  ) extends zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly {
    override val customVerificationEmailTemplates: Optional[
      List[zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customVerificationEmailTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.CustomVerificationEmailTemplate.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse
  ): zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
