package zio.aws.ses.model
import zio.aws.ses.model.primitives.PolicyName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListIdentityPoliciesResponse(
    policyNames: Iterable[PolicyName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListIdentityPoliciesResponse = {
    import ListIdentityPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListIdentityPoliciesResponse
      .builder()
      .policyNames(policyNames.map { item =>
        PolicyName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListIdentityPoliciesResponse.ReadOnly =
    zio.aws.ses.model.ListIdentityPoliciesResponse.wrap(buildAwsValue())
}
object ListIdentityPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListIdentityPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListIdentityPoliciesResponse =
      zio.aws.ses.model.ListIdentityPoliciesResponse(policyNames)
    def policyNames: List[PolicyName]
    def getPolicyNames: ZIO[Any, Nothing, List[PolicyName]] =
      ZIO.succeed(policyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListIdentityPoliciesResponse
  ) extends zio.aws.ses.model.ListIdentityPoliciesResponse.ReadOnly {
    override val policyNames: List[PolicyName] = impl
      .policyNames()
      .asScala
      .map { item =>
        zio.aws.ses.model.primitives.PolicyName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListIdentityPoliciesResponse
  ): zio.aws.ses.model.ListIdentityPoliciesResponse.ReadOnly = new Wrapper(impl)
}
